# This file is generated by numpy's build process
# It contains system_info results at the time of building this package.
from enum import Enum
from numpy._core._multiarray_umath import (
    __cpu_features__,
    __cpu_baseline__,
    __cpu_dispatch__,
)

__all__ = ["show_config"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return {k: _cleanup(v) for k, v in d.items() if v and _cleanup(v)}
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "14.3.0",
                "commands": r"aarch64-poky-linux-gcc, -march=armv8-a+crc+crypto, -mbranch-protection=standard, -fstack-protector-strong, -O2, -D_FORTIFY_SOURCE=2, -Wformat, -Wformat-security, -Werror=format-security, --sysroot=",
                "args": r"-O2, -g, -fcanon-prefix-map, -fmacro-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fdebug-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fmacro-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fdebug-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fdebug-prefix-map=, -fmacro-prefix-map=, -fdebug-prefix-map=, -fmacro-prefix-map=, -pipe",
                "linker args": r"-Wl,-O1, -Wl,--hash-style=gnu, -Wl,--as-needed, -fcanon-prefix-map, -fmacro-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fdebug-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fmacro-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fdebug-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fdebug-prefix-map=, -fmacro-prefix-map=, -fdebug-prefix-map=, -fmacro-prefix-map=, -Wl,-z,relro,-z,now",
            },
            "cython": {
                "name": "cython",
                "linker": r"cython",
                "version": "3.0.12",
                "commands": r"cython3",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "14.3.0",
                "commands": r"aarch64-poky-linux-g++, -march=armv8-a+crc+crypto, -mbranch-protection=standard, -fstack-protector-strong, -O2, -D_FORTIFY_SOURCE=2, -Wformat, -Wformat-security, -Werror=format-security, --sysroot=",
                "args": r"-O2, -g, -fcanon-prefix-map, -fmacro-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fdebug-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fmacro-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fdebug-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fdebug-prefix-map=, -fmacro-prefix-map=, -fdebug-prefix-map=, -fmacro-prefix-map=, -pipe, -fvisibility-inlines-hidden",
                "linker args": r"-Wl,-O1, -Wl,--hash-style=gnu, -Wl,--as-needed, -fcanon-prefix-map, -fmacro-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fdebug-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fmacro-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fdebug-prefix-map=/usr/src/debug/python3-numpy/2.2.3, -fdebug-prefix-map=, -fmacro-prefix-map=, -fdebug-prefix-map=, -fmacro-prefix-map=, -Wl,-z,relro,-z,now",
            },
        },
        "Machine Information": {
            "host": {
                "cpu": "aarch64",
                "family": "aarch64",
                "endian": "little",
                "system": "linux",
            },
            "build": {
                "cpu": "x86_64",
                "family": "x86_64",
                "endian": "little",
                "system": "linux",
            },
            "cross-compiled": bool("True".lower().replace("false", "")),
        },
        "Build Dependencies": {
            "blas": {
                "name": "auto",
                "found": bool("False".lower().replace("false", "")),
                "version": "",
                "detection method": "",
                "include directory": r"",
                "lib directory": r"",
                "openblas configuration": r"",
                "pc file directory": r"",
            },
            "lapack": {
                "name": "lapack",
                "found": bool("False".lower().replace("false", "")),
                "version": "",
                "detection method": "",
                "include directory": r"",
                "lib directory": r"",
                "openblas configuration": r"",
                "pc file directory": r"",
            },
        },
        "Python Information": {
            "path": r"/usr/bin/nativepython3",
            "version": "3.13",
        },
        "SIMD Extensions": {
            "baseline": __cpu_baseline__,
            "found": [
                feature for feature in __cpu_dispatch__ if __cpu_features__[feature]
            ],
            "not found": [
                feature for feature in __cpu_dispatch__ if not __cpu_features__[feature]
            ],
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which NumPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    See Also
    --------
    get_include : Returns the directory containing NumPy C
                  header files.

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )


def show_config(mode=DisplayModes.stdout.value):
    return show(mode)


show_config.__doc__ = show.__doc__
show_config.__module__ = "numpy"
