#pragma once
#include <stdio.h>
#include <string>
#include <iostream>
#include <fstream>
#include <vector>

#include <opencv2/opencv.hpp>

namespace dxapp
{
namespace common
{
    static const std::vector<std::vector<int>> skeleton_nodes = {
        {15, 13},
        {13, 11},
        {16, 14},
        {14, 12},
        {11, 12},
        {5, 11},
        {6, 12},
        {5, 6},
        {5, 7},
        {6, 8},
        {7, 9},
        {8, 10},
        {1, 2},
        {0, 1},
        {0, 2},
        {1, 3},
        {2, 4},
        {3, 5},
        {4, 6},
    };
    
    static const std::vector<cv::Scalar> pose_limb_color = {
        cv::Scalar(  51   ,  153  ,  255  ),
        cv::Scalar(  51   ,  153  ,  255  ),
        cv::Scalar(  51   ,  153  ,  255  ),
        cv::Scalar(  51   ,  153  ,  255  ),
        cv::Scalar(  255  ,  51   ,  255  ),
        cv::Scalar(  255  ,  51   ,  255  ),
        cv::Scalar(  255  ,  51   ,  255  ),
        cv::Scalar(  255  ,  128  ,  0    ),
        cv::Scalar(  255  ,  128  ,  0    ),
        cv::Scalar(  255  ,  128  ,  0    ),
        cv::Scalar(  255  ,  128  ,  0    ),
        cv::Scalar(  255  ,  128  ,  0    ),
        cv::Scalar(  0    ,  255  ,  0    ),
        cv::Scalar(  0    ,  255  ,  0    ),
        cv::Scalar(  0    ,  255  ,  0    ),
        cv::Scalar(  0    ,  255  ,  0    ),
        cv::Scalar(  0    ,  255  ,  0    ),
        cv::Scalar(  0    ,  255  ,  0    ),
        cv::Scalar(  0    ,  255  ,  0    ),
    };

    static const std::vector<cv::Scalar> pose_kpt_color = {
        cv::Scalar(  0    ,  255  ,  0    ),
        cv::Scalar(  0    ,  255  ,  0    ),
        cv::Scalar(  0    ,  255  ,  0    ),
        cv::Scalar(  0    ,  255  ,  0    ),
        cv::Scalar(  0    ,  255  ,  0    ),
        cv::Scalar(  255  ,  128  ,  0    ),
        cv::Scalar(  255  ,  128  ,  0    ),
        cv::Scalar(  255  ,  128  ,  0    ),
        cv::Scalar(  255  ,  128  ,  0    ),
        cv::Scalar(  255  ,  128  ,  0    ),
        cv::Scalar(  255  ,  128  ,  0    ),
        cv::Scalar(  51   ,  153  ,  255  ),
        cv::Scalar(  51   ,  153  ,  255  ),
        cv::Scalar(  51   ,  153  ,  255  ),
        cv::Scalar(  51   ,  153  ,  255  ),
        cv::Scalar(  51   ,  153  ,  255  ),
        cv::Scalar(  51   ,  153  ,  255  ),
    };

    static const std::vector<cv::Scalar> color_table = 
    {
        cv::Scalar(    113    ,    129    ,    39    ),
        cv::Scalar(    133    ,    80    ,    164   ),
        cv::Scalar(    114    ,    122    ,    83    ),
        cv::Scalar(    172    ,    81    ,    99    ),
        cv::Scalar(    104    ,    56    ,    95    ),
        cv::Scalar(    86    ,    84    ,    37        ),
        cv::Scalar(    122    ,    89    ,    14    ),
        cv::Scalar(    65    ,    7    ,    80        ),
        cv::Scalar(    25    ,    102    ,    10        ),
        cv::Scalar(    109    ,    185    ,    90    ),
        cv::Scalar(    132    ,    110    ,    106   ),
        cv::Scalar(    85    ,    158    ,    169       ),
        cv::Scalar(    26    ,    185    ,    188       ),
        cv::Scalar(    17    ,    1    ,    103       ),
        cv::Scalar(    81    ,    144    ,    82        ),
        cv::Scalar(    184    ,    7    ,    92    ),
        cv::Scalar(    155    ,    81    ,    49    ),
        cv::Scalar(    69    ,    177    ,    179       ),
        cv::Scalar(    158    ,    187    ,    93    ),
        cv::Scalar(    73    ,    39    ,    13        ),
        cv::Scalar(    60    ,    50    ,    12        ),
        cv::Scalar(    33    ,    179    ,    16        ),
        cv::Scalar(    165    ,    69    ,    112   ),
        cv::Scalar(    63    ,    139    ,    15        ),
        cv::Scalar(    159    ,    191    ,    33    ),
        cv::Scalar(    32    ,    173    ,    182       ),
        cv::Scalar(    133    ,    113    ,    34    ),
        cv::Scalar(    34    ,    135    ,    90        ),
        cv::Scalar(    86    ,    34    ,    53        ),
        cv::Scalar(    190    ,    35    ,    141   ),
        cv::Scalar(    8    ,    171    ,    6         ),
        cv::Scalar(    112    ,    76    ,    118   ),
        cv::Scalar(    55    ,    60    ,    89        ),
        cv::Scalar(    88    ,    54    ,    15        ),
        cv::Scalar(    181    ,    75    ,    112   ),
        cv::Scalar(    38    ,    147    ,    42        ),
        cv::Scalar(    63    ,    52    ,    138       ),
        cv::Scalar(    149    ,    65    ,    128   ),
        cv::Scalar(    24    ,    103    ,    106       ),
        cv::Scalar(    45    ,    33    ,    168       ),
        cv::Scalar(    135    ,    136    ,    28    ),
        cv::Scalar(    108    ,    91    ,    86    ),
        cv::Scalar(    76    ,    11    ,    52        ),
        cv::Scalar(    189    ,    6    ,    142   ),
        cv::Scalar(    168    ,    81    ,    57    ),
        cv::Scalar(    148    ,    19    ,    55    ),
        cv::Scalar(    89    ,    101    ,    182       ),
        cv::Scalar(    179    ,    65    ,    44    ),
        cv::Scalar(    26    ,    33    ,    1         ),
        cv::Scalar(    26    ,    164    ,    122       ),
        cv::Scalar(    134    ,    63    ,    70    ),
        cv::Scalar(    82    ,    106    ,    137       ),
        cv::Scalar(    52    ,    118    ,    120       ),
        cv::Scalar(    42    ,    74    ,    129       ),
        cv::Scalar(    112    ,    147    ,    182   ),
        cv::Scalar(    50    ,    157    ,    22        ),
        cv::Scalar(    20    ,    50    ,    56        ),
        cv::Scalar(    177    ,    22    ,    2     ),
        cv::Scalar(    106    ,    100    ,    156   ),
        cv::Scalar(    42    ,    35    ,    21        ),
        cv::Scalar(    121    ,    8    ,    13    ),
        cv::Scalar(    28    ,    92    ,    142       ),
        cv::Scalar(    33    ,    118    ,    45        ),
        cv::Scalar(    30    ,    118    ,    105       ),
        cv::Scalar(    124    ,    185    ,    7     ),
        cv::Scalar(    146    ,    34    ,    46    ),
        cv::Scalar(    169    ,    184    ,    105   ),
        cv::Scalar(    5    ,    18    ,    22        ),
        cv::Scalar(    73    ,    71    ,    147       ),
        cv::Scalar(    91    ,    64    ,    181       ),
        cv::Scalar(    184    ,    39    ,    31    ),
        cv::Scalar(    33    ,    179    ,    164       ),
        cv::Scalar(    18    ,    50    ,    96        ),
        cv::Scalar(    106    ,    15    ,    95    ),
        cv::Scalar(    54    ,    68    ,    113       ),
        cv::Scalar(    112    ,    116    ,    136   ),
        cv::Scalar(    130    ,    139    ,    119   ),
        cv::Scalar(    34    ,    139    ,    31        ),
        cv::Scalar(    127    ,    6    ,    66    ),
        cv::Scalar(    2    ,    39    ,    62        ),
        cv::Scalar(    180    ,    99    ,    49    ),
        cv::Scalar(    155    ,    119    ,    49    ),
        cv::Scalar(    183    ,    50    ,    153   ),
        cv::Scalar(    3    ,    38    ,    125       ),
        cv::Scalar(    143    ,    87    ,    129   ),
        cv::Scalar(    40    ,    87    ,    49        ),
        cv::Scalar(    120    ,    62    ,    128   ),
        cv::Scalar(    148    ,    85    ,    73    ),
        cv::Scalar(    118    ,    144    ,    28    ),
        cv::Scalar(    24    ,    9    ,    29        ),
        cv::Scalar(    108    ,    45    ,    175   ),
        cv::Scalar(    64    ,    175    ,    81        ),
        cv::Scalar(    157    ,    19    ,    178   ),
        cv::Scalar(    190    ,    188    ,    74    ),
        cv::Scalar(    2    ,    114    ,    18        ),
        cv::Scalar(    96    ,    128    ,    62        ),
        cv::Scalar(    150    ,    3    ,    21    ),
        cv::Scalar(    95    ,    6    ,    0         ),
        cv::Scalar(    184    ,    20    ,    2     ),
        cv::Scalar(    185    ,    37    ,    122   ),
    };   
} // namespace common
} // namespace dxapp
